VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "Msflxgrd.ocx"
Begin VB.Form HSDigOut 
   BackColor       =   &H00C0C0C0&
   Caption         =   "High Speed DO and Simultaneous AI with the KPCI-3100"
   ClientHeight    =   5415
   ClientLeft      =   1515
   ClientTop       =   1740
   ClientWidth     =   8130
   ForeColor       =   &H00000000&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   5415
   ScaleWidth      =   8130
   Begin VB.TextBox TBBufferSize 
      Enabled         =   0   'False
      Height          =   285
      Left            =   2280
      TabIndex        =   23
      Top             =   3840
      Width           =   1095
   End
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "&Update Grid"
      Height          =   495
      Left            =   840
      TabIndex        =   22
      Top             =   3600
      Width           =   1284
   End
   Begin VB.TextBox TBSpeed 
      Height          =   285
      Left            =   4920
      TabIndex        =   20
      Top             =   3840
      Width           =   1095
   End
   Begin VB.TextBox TBDataLost 
      Height          =   285
      Left            =   3600
      TabIndex        =   17
      Top             =   4440
      Width           =   1095
   End
   Begin VB.TextBox TBBuffersFilled 
      Height          =   285
      Left            =   3600
      TabIndex        =   16
      Top             =   3840
      Width           =   1095
   End
   Begin MSFlexGridLib.MSFlexGrid Grid1 
      Height          =   3015
      Left            =   120
      TabIndex        =   15
      Top             =   480
      Width           =   3015
      _ExtentX        =   5318
      _ExtentY        =   5318
      _Version        =   393216
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "S&top"
      Enabled         =   0   'False
      Height          =   495
      Left            =   6600
      TabIndex        =   14
      Top             =   4200
      Width           =   1284
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "&Clear"
      Height          =   420
      Left            =   6816
      TabIndex        =   3
      Top             =   2805
      Width           =   948
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   "De&lete"
      Height          =   420
      Left            =   5280
      TabIndex        =   2
      Top             =   2805
      Width           =   948
   End
   Begin VB.CommandButton cmdAdd 
      Caption         =   "&A&dd"
      Height          =   420
      Left            =   3600
      TabIndex        =   1
      Top             =   2805
      Width           =   948
   End
   Begin VB.ComboBox cmbAvailableChannels 
      Height          =   315
      Left            =   3360
      TabIndex        =   4
      Top             =   840
      Width           =   1500
   End
   Begin VB.ListBox ChannelList 
      Height          =   1815
      Left            =   6360
      MultiSelect     =   2  'Extended
      TabIndex        =   5
      Top             =   840
      Width           =   1350
   End
   Begin VB.Frame frameChannelSelector 
      Caption         =   "Channel Gain List"
      Height          =   3300
      Left            =   3150
      TabIndex        =   9
      Top             =   240
      Width           =   4785
      Begin VB.TextBox TBDigOut 
         Height          =   285
         Left            =   2040
         TabIndex        =   12
         Text            =   "0"
         Top             =   620
         Width           =   855
      End
      Begin VB.Label Label2 
         Alignment       =   2  'Center
         Caption         =   "Digital Data (0..255)"
         Height          =   375
         Left            =   1920
         TabIndex        =   13
         Top             =   240
         Width           =   1095
      End
      Begin VB.Label lblSelectedChannels 
         Caption         =   "Channel / Dig Data"
         Height          =   210
         Index           =   1
         Left            =   3240
         TabIndex        =   11
         Top             =   315
         Width           =   1425
      End
      Begin VB.Label lblAvailableChannel 
         Caption         =   "Available Channels:"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   10
         Top             =   360
         Width           =   1440
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   492
      Left            =   6600
      TabIndex        =   6
      Top             =   4800
      Width           =   1284
   End
   Begin VB.CommandButton cmdAcquire 
      Caption         =   "&Start"
      Default         =   -1  'True
      Height          =   492
      Left            =   6600
      TabIndex        =   0
      Top             =   3600
      Width           =   1284
   End
   Begin DlsrLib.DriverLINXLDD DriverLINXLDD1 
      Left            =   6120
      Top             =   4320
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   6120
      Top             =   4800
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label7 
      Alignment       =   2  'Center
      Caption         =   "Data Buffer"
      Height          =   255
      Left            =   120
      TabIndex        =   25
      Top             =   240
      Width           =   3015
   End
   Begin VB.Label Label3 
      Alignment       =   2  'Center
      Caption         =   "Buffer Size"
      Height          =   255
      Left            =   2280
      TabIndex        =   24
      Top             =   3600
      Width           =   1095
   End
   Begin VB.Label Label6 
      Alignment       =   2  'Center
      Caption         =   "Avg Rdgs (Hz)"
      Height          =   255
      Left            =   4920
      TabIndex        =   21
      Top             =   3600
      Width           =   1095
   End
   Begin VB.Label Label5 
      Alignment       =   2  'Center
      Caption         =   "Data Lost"
      Height          =   255
      Left            =   3600
      TabIndex        =   19
      Top             =   4200
      Width           =   1095
   End
   Begin VB.Label Label4 
      Alignment       =   2  'Center
      Caption         =   "Buffers Filled"
      Height          =   255
      Left            =   3600
      TabIndex        =   18
      Top             =   3600
      Width           =   1095
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Status "
      Height          =   195
      Left            =   210
      TabIndex        =   8
      Top             =   4605
      Width           =   480
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      Height          =   315
      Left            =   120
      TabIndex        =   7
      Top             =   4875
      Width           =   5925
   End
End
Attribute VB_Name = "HSDigOut"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' This example demonstrates how to acquire a single buffer of data
' from multiple channels using your board's analog input subsystem.
' This example displays how to use and implement a channel gain list.
' It performs seven DriverLINX operations:
'   1. Open a DriverLINX driver
'   2. Initialize a Logical Device
'   3. See if the Logical Device supports analog input
'   4. Setup the Service Request
'   5. Execute the Service Request
'   6. Process the results
'   7. Close the DriverLINX driver
'
' This application performs steps 1, 2, 3, 4, and 7 once. Every time
'   that you click the form's "Acquire" button, it performs steps 5.
'   It uses the DriverLINXSR bufferFilled event to know when to perform
'   step 6.
'
' Code for this example is divided between three modules:
'   AIMultChForm, which you will find in the file, AIMultCh.frm,
'   DriverLINXGUIInterface, which you will find in DLVBGUI.bas, and
'   DriverLINXLibrary, which you will find in the file DLVBLib.bas.
'
' To the extent possible, DriverLINXLibrary contains all
'   DriverLINX/VB-specific code.
'
' AIMultChForm is organized as follows:
'
'   Form_Load() opens a DriverLINX driver, initializes a Logical Device,
'       and checks whether the Logical Device supports analog input.
'
'   Form_Load() then sets up a Service Request that, when executed, will
'       acquire a single, buffer of data from the Logical Device's
'       analog-input susbsystem.
'
'   cmdAcquire_Click() executes the Service Request setup by
'       Form_Load(), and displays the acquired value, along
'       with any error messages from DriverLINX.
'
'   ChannelList list box contains all of the selected channels and the
'       order of the channel gain list.
'
'   cmbAvailableChannels this combo box displays all available channels
'       that can be added to the channel gain list.
'
'   cmdAdd() transfer selection from the available channels combo box
'       to the selected channels list box.
'
'   cmdDelete() removes the selected item in the selected channels list box.
'
'   cmdClear() removes all items in the selected channels list box.
'
'   DriverLINXSR1_ServiceStart() updates the form to indicate that a task
'       is currently running.
'
'   DriverLINXSR1_BufferFilled() retrieves data from the DriverLINXSR
'       control, and plots it on the form's CRT panel.
'
'   DriverLINXSR1_ServiceDone() updates the form to indicate that a task
'       has ended.
'
'   cmdExit_Click() stops any active DriverLINX task, and then closes the
'       DriverLINX driver opened in Form_Load().
'

' With the Option Explicit statement, VB will help catch typing errors
Option Explicit

Const CHAN_SE_DIG As Integer = 2 ^ 13
Const CHAN_OEM_FLAG As Integer = (-2) ^ 15
Const CHAN_OEM_SHIFT As Integer = 2 ^ 4
Const CHAN_OEM_MASK As Integer = 3  '3110,3116 have only two digital outputs.
Const HAVE_3110_OR_3116 As Boolean = True

Const LogicalDevice As Integer = 2          ' DriverLINX Logical Device
Const LogicalChannel As Integer = 0         ' Default Logical Channel
Const ChannelGain As Single = -1#           ' Default Channel Gain
Private NumberOfChannels As Integer         ' Number of channels sampled
Dim LogicalChannels() As Integer  ' DriverLINX Logical Channel
Dim ChannelGains() As Single      ' Gain setting for Logical Channel
Dim DigitalData() As Integer      ' For dynamic digital outputs.

Dim startTimer, lastTimer As Long
' Sampling frequency = 10 kHz
Const SamplingFrequency As Single = 250000#
Const SamplingPeriod As Single = 1 / SamplingFrequency

' Number of buffers
Const NumberOfBuffers As Integer = 4

' Number of samples per channel in a buffer
Const NumberOfSamples As Single = 1000
    
' Duration of data acquisition
Const FullSweep As Single = NumberOfSamples * SamplingPeriod

' A data storage array
Dim DataArray() As Single

' Status string
Private strStatus As String
' Status strings that indicate normal operation
Const msgRunning As String = "Running"
Const msgStopped As String = "Stopped"

Const BackGroundForeGround As Integer = 1     'IRQ or DMA = 1, Polled = 0

'Graphing Constants
Const Digital As Boolean = False                 'This is a analog I/O example
Const YAxisOffset = 0

Private Sub cmdAdd_Click()
Dim i As Integer
Dim x As Long, y As Long
Dim chn As Integer, dig As Integer

'Add Combo box entry to List box
ChannelList.AddItem (cmbAvailableChannels.Text + " / " + TBDigOut.Text)
cmdDelete.Enabled = True

' Update the number of channels sampled assume 1 as default
    NumberOfChannels = ChannelList.ListCount
    
    'Redim arrays
    ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Single
    ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
    ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
    ReDim DigitalData(0 To NumberOfChannels - 1) As Integer
    Call InitGrid
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        x = InStr(1, ChannelList.List(i), "/")
        chn = Mid(ChannelList.List(i), 1, x - 1)
        y = x + 2
        dig = Mid(ChannelList.List(i), y)
        'Debug.Print i, x, chn, y, dig
        ChannelGains(i) = ChannelGain
        LogicalChannels(i) = chn
        DigitalData(i) = dig
    Next i
    
    'Update Channel Gain List and Buffers
    'AddChannelGainList DriverLINXSR1, DL_AI, NumberOfChannels, LogicalChannels(), ChannelGains()
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels
    
    DriverLINXSR1.Sel_chan_N = NumberOfChannels
    DriverLINXSR1.Sel_chan_format = DL_tNATIVE
    
    For i = 0 To NumberOfChannels - 1
        DriverLINXSR1.Sel_chan_list(i) = LogicalChannels(i)
        DriverLINXSR1.Sel_chan_gainCodeList(i) = DriverLINXSR1.DLGain2Code(ChannelGains(i)) _
                                        Or (DigitalData(i) * CHAN_OEM_SHIFT) _
                                        Or CHAN_OEM_FLAG
    Next i

End Sub

Private Sub cmdClear_Click()
Dim i As Integer
Dim chn, dig As Integer
Dim x, y As Long

'Clear List box
    ChannelList.Clear

' Update the number of channels sampled assume 1 as default
    NumberOfChannels = ChannelList.ListCount
        
 'Redim arrays
    If (NumberOfChannels > 0) Then
        ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
        ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
        ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Single
        ReDim DigitalData(0 To NumberOfChannels - 1) As Integer
    Else
        ReDim ChannelGains(0) As Single
        ReDim LogicalChannels(0) As Integer
        ReDim DataArray(0, 0 To NumberOfSamples - 1) As Single
        ReDim DigitalData(0 To NumberOfChannels - 1) As Integer
    End If
    
    Call InitGrid
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        x = InStr(1, ChannelList.List(i), "/")
        chn = Mid(ChannelList.List(i), 1, x - 1)
        y = x + 2
        dig = Mid(ChannelList.List(i), y)
        'Debug.Print i, x, chn, y, dig
        ChannelGains(i) = ChannelGain
        LogicalChannels(i) = chn
        DigitalData(i) = dig
    Next i
    
'Update Channel Gain List and Buffers
    'AddChannelGainList DriverLINXSR1, DL_AI, NumberOfChannels, LogicalChannels(), ChannelGains()
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels
    
    DriverLINXSR1.Sel_chan_N = NumberOfChannels
    DriverLINXSR1.Sel_chan_format = DL_tNATIVE
    
    For i = 0 To NumberOfChannels - 1
        DriverLINXSR1.Sel_chan_list(i) = LogicalChannels(i)
        DriverLINXSR1.Sel_chan_gainCodeList(i) = DriverLINXSR1.DLGain2Code(ChannelGains(i)) _
                                        Or (DigitalData(i) * CHAN_OEM_SHIFT) _
                                        Or CHAN_OEM_FLAG
    Next i

'disable the Delete button until atleast one channel has been added
    cmdDelete.Enabled = False
End Sub

Private Sub cmdDelete_Click()
'Remove Selected Channel(s) from listbox
Dim Entries, i As Integer
Dim chn, dig As Integer
Dim x, y As Long

'Warn user to select something first
    If ChannelList.SelCount = 0 Then
     MsgBox "There are no selected Channels to Delete!", vbOKOnly, "OOPS!"
        Exit Sub
    End If

'Check which channels were selected and delete channel if selected by user
    Entries = ChannelList.ListCount - 1
    For i = Entries To 0 Step -1
        If ChannelList.Selected(i) = True Then
          ChannelList.RemoveItem i
        End If
    Next i

' Update the number of channels sampled assume 1 as default
    NumberOfChannels = ChannelList.ListCount
    
'Redim arrays
    If (NumberOfChannels > 0) Then
        ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
        ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
        ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Single
        ReDim DigitalData(0 To NumberOfChannels - 1) As Integer
    Else
        ReDim ChannelGains(0) As Single
        ReDim LogicalChannels(0) As Integer
        ReDim DataArray(0, 0 To NumberOfSamples - 1) As Single
        ReDim DigitalData(0 To NumberOfChannels - 1) As Integer
    End If
    
    Call InitGrid
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        x = InStr(1, ChannelList.List(i), "/")
        chn = Mid(ChannelList.List(i), 1, x - 1)
        y = x + 2
        dig = Mid(ChannelList.List(i), y)
        'Debug.Print i, x, chn, y, dig
        ChannelGains(i) = ChannelGain
        LogicalChannels(i) = chn
        DigitalData(i) = dig
    Next i
    
'Update Channel Gain List and Buffers
    'AddChannelGainList DriverLINXSR1, DL_AI, NumberOfChannels, LogicalChannels(), ChannelGains()
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels
    
    DriverLINXSR1.Sel_chan_N = NumberOfChannels
    DriverLINXSR1.Sel_chan_format = DL_tNATIVE
    
    For i = 0 To NumberOfChannels - 1
        DriverLINXSR1.Sel_chan_list(i) = LogicalChannels(i)
        DriverLINXSR1.Sel_chan_gainCodeList(i) = DriverLINXSR1.DLGain2Code(ChannelGains(i)) _
                                        Or (DigitalData(i) * CHAN_OEM_SHIFT) _
                                        Or CHAN_OEM_FLAG
    Next i

'If no channels left disable the delete button
    If NumberOfChannels = 0 Then cmdDelete.Enabled = False
End Sub

Private Sub cmdStop_Click()

    Dim DLStatusCode As Integer
    
    ' Make sure that there are no active tasks
    DLStatusCode = StopDriverLINXIO(DriverLINXSR1)
    
    ' If active task is found, do not exit until DriverLINX notifies
    '   you that it is really done.
    If DLStatusCode = DL_NoErr Then
        Do
            DoEvents
        Loop Until cmdAcquire.Enabled
    End If
    TBDataLost.Text = 0
    TBBuffersFilled.Text = 0

End Sub

Private Sub cmdUpdate_Click()

    Call UpdateGrid
End Sub

Private Sub DriverLINXSR1_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
    Static i As Integer
    
    'Display Message
    lblStatus.Caption = "Data Lost"
    
    TBDataLost.Text = Val(TBDataLost.Text) + 1
    
    InitializeDriverLINXDevice DriverLINXSR1, LogicalDevice
    SetupDriverLINXContinuousBufferedIO DriverLINXSR1, DriverLINXLDD1, LogicalDevice, DL_AI, LogicalChannel, ChannelGain, SamplingFrequency, NumberOfSamples, NumberOfBuffers, BackGroundForeGround
    AddSelectBuffers DriverLINXSR1, NumberOfBuffers, NumberOfSamples, NumberOfChannels
    
    DriverLINXSR1.Sel_chan_N = NumberOfChannels
    DriverLINXSR1.Sel_chan_format = DL_tNATIVE
    
    For i = 0 To NumberOfChannels - 1
        DriverLINXSR1.Sel_chan_list(i) = LogicalChannels(i)
        DriverLINXSR1.Sel_chan_gainCodeList(i) = DriverLINXSR1.DLGain2Code(ChannelGains(i)) _
                                        Or (DigitalData(i) * CHAN_OEM_SHIFT) _
                                        Or CHAN_OEM_FLAG
    Next i
    i = 0
    
    cmdAcquire.Enabled = False
    cmdStop.Enabled = True
    DriverLINXSR1.Refresh
End Sub

Private Sub Form_Load()

    Dim DLDriverName As String
    Dim DLResultCode As Integer
    Dim DLMessage As String
    Dim channelNumber As Integer
    Dim i, chn, dig As Integer
    Dim x, y As Long
    Dim mode As Integer
    Dim Model As String
    Dim Msg As String
    
    ' Make sure that this form is centered on the screen
    CenterForm Me
    
    'disable the Delete button until atleast one channel has been added
    cmdDelete.Enabled = False
    
    ' 1. Open a DriverLINX Driver
    DLDriverName = OpenDriverLINXDriver(DriverLINXSR1, "KPCI3100", True)
    If DLDriverName = "" Then
        ' If no driver opened, report this in a message box.
        MsgBox "DriverLINX driver not opened.", vbOKOnly, Me.Name
        
        ' Then close the application
        End
    End If
    
    ' 2. Initialize a Logical Device
    DLResultCode = InitializeDriverLINXDevice(DriverLINXSR1, LogicalDevice)
    If DLResultCode <> DL_NoErr Then
        ' If initialization fails, report the error in a message box
        ShowDriverLINXStatus DriverLINXSR1
        
        ' Then close the application
        End
    End If
    
    'Get Model name may be needed for messages
    Model = GetModelName(DriverLINXSR1, DriverLINXLDD1)
    
    ' 3. See if the Logical Device supports an analog-input subsystem
    If Not HasDriverLINXSubsystem(DriverLINXSR1, DriverLINXLDD1, DL_AI) Then
        ' If it does not, report this in a message box.
        Msg = "This " & Model & " does not support analog input"
        MsgBox Msg, vbOKOnly, Me.Name
        ' Then close the application
        End
    End If

    
    ' If initialization succeeded, report the success on the form
    GetDriverLINXStatus DriverLINXSR1, DLMessage
    lblStatus.Caption = DLMessage
    
    ' Scale form's CRT panel
    'InitCRT pictureCRT, FullSweep, 20, Digital, YAxisOffset
                                 'scale graph for 20 volts
    TBBuffersFilled.Text = 0
    TBDataLost.Text = 0
    TBBufferSize.Text = NumberOfSamples
    
    ' Get the number of analog input channels that this device supports
    channelNumber = HowManyDriverLINXLogicalChannels(DriverLINXSR1, DriverLINXLDD1, DL_AI)
    
    'Fill Combo box with available Channels
    For i = 0 To channelNumber - 1
        cmbAvailableChannels.AddItem (i)
    Next i
    
    'Set Combo box text field to first entry
    cmbAvailableChannels.Text = cmbAvailableChannels.List(0)
    
    'Set Channel Gain List to channel 0 as default
    ChannelList.AddItem (cmbAvailableChannels.Text + " / " + TBDigOut.Text)
    cmdDelete.Enabled = True    'Enabled Delete button
        
    ' Update the number of channels sampled assume 1 as default
    NumberOfChannels = 1
    
    'Redim arrays
    ReDim DataArray(0 To NumberOfChannels - 1, 0 To NumberOfSamples - 1) As Single
    ReDim ChannelGains(0 To NumberOfChannels - 1) As Single
    ReDim LogicalChannels(0 To NumberOfChannels - 1) As Integer
    ReDim DigitalData(0 To NumberOfChannels - 1) As Integer
    
    Call InitGrid
    
    For i = 0 To NumberOfChannels - 1           'Update Array Information
        x = InStr(1, ChannelList.List(i), "/")
        chn = Mid(ChannelList.List(i), 1, x - 1)
        y = x + 2
        dig = Mid(ChannelList.List(i), y)
        'Debug.Print i, x, chn, y, dig
        ChannelGains(i) = ChannelGain
        LogicalChannels(i) = chn
        DigitalData(i) = dig
    Next i
                                                                                                                           
    ' 4. Setup the Service Request control for Multi-Channel, analog input
    '    utilizing a channel gain list.
    SetupDriverLINXMultiChannelGainList DriverLINXSR1, DriverLINXLDD1, LogicalDevice, _
                                        DL_AI, LogicalChannels(), ChannelGains(), _
                                        SamplingFrequency, NumberOfSamples, _
                                        NumberOfChannels, NumberOfBuffers, _
                                        BackGroundForeGround
    ' See CmdAcquire_Click( ) for how to start this task and process data
    AddStopEventOnCommand DriverLINXSR1
    
End Sub


Private Sub cmdAcquire_Click()

    Dim DLMessage As String
    Dim DLResultCode As Integer
    Dim i As Integer

    ' 5. Execute the Service Request specified when this
    '    form loaded. (See Form_Load( ) for details.)
    DriverLINXSR1.Refresh
    ' NOTE: Bufered I/O tasks execute asynchronously, i.e., the data
    '       is not available when the call to the Refresh method
    '       returns. To process results from buffered I/O tasks, handle
    '       events from the DriverLINXSR control. In this example, see
    '       the following subroutines:
    '           DriverLINXSR1_ServiceStart,
    '           DriverLINXSR1_BufferFilled, and
    '           DriverLINXSR1_ServiceDone.
    
    ' Display status or error information in this form's status box
    DLResultCode = GetDriverLINXStatus(DriverLINXSR1, DLMessage)
    If DLResultCode <> DL_NoErr Then
        Debug.Print "Result Code = " & DLResultCode
        strStatus = DLMessage
    End If
    
    lblStatus.Caption = strStatus
    
End Sub


Private Sub DriverLINXSR1_ServiceStart(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The DriverLINXSR calls this subroutine when a task starts. This
    '   application uses this ServiceStart event to update the form,
    '   indicating that a task is currently running.
    strStatus = msgRunning
    lblStatus.Caption = strStatus
    
    ' Disable the start button while a task is running
    cmdAcquire.Enabled = False
    cmdStop.Enabled = True
    cmdUpdate.Enabled = False
    startTimer = Timer

End Sub


Private Sub DriverLINXSR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
    
    Dim samples As Long
    Dim channels As Integer
    
    ' 6. Process results:
    '    Because buffered I/O tasks execute asynchronously, your
    '    application will not have any data to process until your
    '    DriverLINXSR control informs it that a buffer has filled.
    '    When you set the DriverLINXSR property, Sel_buf_notify, equal
    '    to DL_NOTIFY, the DriverLINXSR control calls this subroutine
    '    whenever it has filled a buffer with new data. At this point,
    '    you can transfer the data in this buffer from the DriverLINXSR
    '    control to an array defined in your application.
    samples = GetDriverLINXAIBuffer(DriverLINXSR1, bufIndex, DataArray())
    
    TBBuffersFilled.Text = Val(TBBuffersFilled.Text) + 1
    
    If TBBuffersFilled.Text Mod 4 = 0 Then
        TBSpeed.Text = NumberOfChannels * NumberOfSamples * Val(TBBuffersFilled.Text) / (Timer - startTimer)
    End If
    
    ' Display the new data
    'ShowAnalogResults pictureCRT, NumberOfChannels, NumberOfSamples, SamplingFrequency, DataArray()
    
End Sub


Private Sub DriverLINXSR1_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)

    ' The DriverLINXSR calls this subroutine when a task ends. This
    '   application uses this ServiceDone event to update the form,
    '   indicating that no task is running.
    strStatus = msgStopped
    lblStatus.Caption = strStatus
    
    ' Reenable the start button when a task ends.
    cmdAcquire.Enabled = True
    cmdStop.Enabled = False
    cmdUpdate.Enabled = True
    
End Sub


Private Sub cmdExit_Click()

    Dim DLStatusCode As Integer
    
    ' Make sure that there are no active tasks
    DLStatusCode = StopDriverLINXIO(DriverLINXSR1)
    
    ' If active task is found, do not exit until DriverLINX notifies
    '   you that it is really done.
    If DLStatusCode = DL_NoErr Then
        Do
            DoEvents
        Loop Until cmdAcquire.Enabled
    End If
            
    ' 7. Close the DriverLINX Driver
    CloseDriverLINXDriver DriverLINXSR1
    
    ' Quit this application
    End

End Sub


Private Sub TBDigOut_LostFocus()

    If Val(TBDigOut.Text) > 255 Then TBDigOut.Text = 255
    If Val(TBDigOut.Text) < 0 Then TBDigOut.Text = 0
    
    If HAVE_3110_OR_3116 Then
        TBDigOut.Text = Val(TBDigOut.Text) And CHAN_OEM_MASK
    End If
End Sub

Private Sub InitGrid()

    Dim i As Integer
    Grid1.Cols = NumberOfChannels + 1
    Grid1.ColWidth(0) = 620
    
    For i = 1 To Grid1.Cols - 1
        Grid1.ColWidth(i) = 1000
        Grid1.TextArray(faIndex(0, i)) = "Entry " + Str(i)
    Next i
    
    Grid1.TextArray(faIndex(0, 0)) = "Sample"
    
    Grid1.Rows = NumberOfSamples + 1
    
End Sub

Private Sub UpdateGrid()
        
    Dim i As Long
    Dim j As Integer
    Dim k As Integer
    Dim temp As String
    temp = lblStatus.Caption
    
    cmdAcquire.Enabled = False
    lblStatus.Caption = "Updating Data Grid . . .0%"
    k = 0
    
    For i = 0 To NumberOfSamples - 1
        If i Mod (NumberOfSamples \ 100) = 0 Then
            lblStatus.Caption = "Updating Data Grid . . ." + Str(k) + "%"
            k = k + 1
        End If
        
        For j = 1 To NumberOfChannels
            Grid1.TextArray(faIndex(i + 1, j)) = DataArray(j - 1, i)
            DoEvents
        Next j
        
        Grid1.TextArray(faIndex(i + 1, 0)) = i
    Next i
    lblStatus.Caption = temp
    cmdAcquire.Enabled = True
    
End Sub
Private Function faIndex(ByVal row As Integer, ByVal col As Integer) As Long
    'Quick conversion function (lifted from help file).
    faIndex = row * Grid1.Cols + col
End Function


